package w83b.w83bDAO;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDiferenciasBean;
import w83b.w83bBeans.W83bEscrutinioBean;
import w83b.w83bBeans.W83bResultadosBean;
import w83b.w83bDAO.w83bConstantesBD.W83bActasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bDiferenciasBD;
import w83b.w83bDAO.w83bConstantesBD.W83bEscrutiniosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bResultadosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bSindicatosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


// TODO: Auto-generated Javadoc
/**
 * The Class W83bResultadosDAO.
 */
public class W83bResultadosDAO implements W83bIResultadosDAO {
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarResCentroSindicato(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarResCentroSindicato(w83b.w83bBeans.W83bResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		if(!StringUtils.isNotEmpty(param.getFechaHistorico())){
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append("SELECT ");
				
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.anoregdef).append(", ");
				strSql.append(W83bResultadosBD.nregdef).append(", ");
				strSql.append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.razon).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codsindicato);
				strSql.append(" from ( ");
				
			}
			strSql.append("SELECT "); 
			if(contar){
				strSql.append(" count(");
				strSql.append(W83bResultadosBD.nacta).append(")");
			}else{
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.anoregdef).append(", ");
				strSql.append(W83bResultadosBD.nregdef).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.razon).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append("  row_number() over ( ");
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.nactacompleta);
				strSql.append(") as rn");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			strSql.append(" FROM W83B.").append(W83bResultadosBD.vistaResCenSind);
			strSql.append(" WHERE ");
//			strSql.append(" 1=1 ");
			//SOLO PARA PROBAR DE QUE SALE COMO EL RESTO DE LOS INFORMES
//			strSql.append(" fecharegistro<=TO_DATE('01/03/1998','dd/MM/yyyy') and ");
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefDesde())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.nregdef).append(">=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoregdef).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefDesde());
				params.add(param.getNumRegDefDesde());
				params.add(param.getAnoRegDefDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefDesde())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoregdef).append(">=").append("? ");
					params.add(param.getAnoRegDefDesde());
			}
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefHasta())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.nregdef).append("<=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoregdef).append("<").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefHasta());
				params.add(param.getNumRegDefHasta());
				params.add(param.getAnoRegDefHasta());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefHasta())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoregdef).append("<=").append("? ");
					params.add(param.getAnoRegDefHasta());
				}
			}
			if(StringUtils.isNotEmpty(param.getNumActaDesde())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.nacta).append(">=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.anoacta).append("=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoacta).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nacta).append(">=0))");
				params.add(param.getAnoActaDesde());
				params.add(param.getNumActaDesde());
				params.add(param.getAnoActaDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaDesde())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoacta).append(">=").append("? ");
					params.add(param.getAnoActaDesde());
				}
			}
			
			if(StringUtils.isNotEmpty(param.getNumActaHasta())){
					strSql.append(" AND ((");
					strSql.append(W83bResultadosBD.nacta).append("<=").append("? ");
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoacta).append("=").append("? ");
					strSql.append(") OR (");
					strSql.append(W83bResultadosBD.anoacta).append("<").append("? ");
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.nacta).append(">=0))");
					params.add(param.getAnoActaHasta());
					params.add(param.getNumActaHasta());
					params.add(param.getAnoActaHasta());
				}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaHasta())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoacta).append("<=").append("? ");
					params.add(param.getAnoActaHasta());
				}
				}
			if(StringUtils.isNotEmpty(param.getFelecDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFelecDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFelecHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFelecHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}

			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFelecHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
//				strSql.append(" OR ("); 
//				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
//				strSql.append(" AND ");  
//				strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')");
//				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFelecHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
//				strSql.append(" )");
				strSql.append(") ");  
				
				if(!contar & !(param.getMin().equals(param.getMax()))){
					strSql.append(") where (rn>? AND rn<=?)");
					params.add(param.getMin());
					params.add(param.getMax());				
				}
				
			//}
			//strSql.append(" ORDER BY ");
			//strSql.append(W83bResultadosBD.nactacompleta);
		}else{
			strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append("SELECT "); 
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.anoregdef).append(", ");
				strSql.append(W83bResultadosBD.nregdef).append(", ");
				strSql.append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.razon).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(" , ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", rn");
				strSql.append(" from(");
				
			}
			strSql.append("SELECT "); 
			if(contar){
				strSql.append(" count(");
				strSql.append(W83bResultadosBD.nacta).append(")");
			}else{
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.anoregdef).append(", ");
				strSql.append(W83bResultadosBD.nregdef).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.razon).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append("SUM(").append(W83bResultadosBD.numdelegados).append(") AS ").append(W83bResultadosBD.numdelegados).append(" , ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append("  row_number() over ( ");
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.nactacompleta);
				strSql.append(") as rn");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			strSql.append(" FROM W83B.").append(W83bResultadosBD.vistaResCenSindHist);
			strSql.append(" WHERE ");
			//SOLO PARA PROBAR DE QUE SALE COMO EL RESTO DE LOS INFORMES
//			strSql.append(" fecharegistro<=TO_DATE('01/03/1998','dd/MM/yyyy') and ");
			if(StringUtils.isNotEmpty(param.getTerritorio())){
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
//				strSql.append(W83bResultadosBD.territ).append(" in").append("(01,48,20) ");
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefDesde())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoregdef).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefDesde());
				params.add(param.getNumRegDefDesde());
				params.add(param.getAnoRegDefDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefDesde())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoregdef).append(">=").append("? ");
					params.add(param.getAnoRegDefDesde());
			}
			}
			if(StringUtils.isNotEmpty(param.getNumRegDefHasta())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.anoregdef).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append("<=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoregdef).append("<").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nregdef).append(">=0))");
				params.add(param.getAnoRegDefHasta());
				params.add(param.getNumRegDefHasta());
				params.add(param.getAnoRegDefHasta());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoRegDefHasta())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoregdef).append("<=").append("? ");
					params.add(param.getAnoRegDefHasta());
				}
			}
			if(StringUtils.isNotEmpty(param.getNumActaDesde())){
				strSql.append(" AND ((");
				strSql.append(W83bResultadosBD.anoacta).append("=").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nacta).append(">=").append("? ");
				strSql.append(") OR (");
				strSql.append(W83bResultadosBD.anoacta).append(">").append("? ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.nacta).append(">=0))");
				params.add(param.getAnoActaDesde());
				params.add(param.getNumActaDesde());
				params.add(param.getAnoActaDesde());
			}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaDesde())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoacta).append(">=").append("? ");
					params.add(param.getAnoActaDesde());
				}
			}
			
			if(StringUtils.isNotEmpty(param.getNumActaHasta())){
					strSql.append(" AND ((");
					strSql.append(W83bResultadosBD.anoacta).append("=").append("? ");
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.nacta).append("<=").append("? ");
					strSql.append(") OR (");
					strSql.append(W83bResultadosBD.anoacta).append("<").append("? ");
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.nacta).append(">=0))");
					params.add(param.getAnoActaHasta());
					params.add(param.getNumActaHasta());
					params.add(param.getAnoActaHasta());
				}
			else{
				if(StringUtils.isNotEmpty(param.getAnoActaHasta())){
					strSql.append(" AND ");
					strSql.append(W83bResultadosBD.anoacta).append("<=").append("? ");
					params.add(param.getAnoActaHasta());
				}
				}
			if(StringUtils.isNotEmpty(param.getFelecDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFelecDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFelecHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFelecHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}

			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFelecHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) ");  
			//}
				//20150723 73618 se aade la fecha de registro en caso que se solicite el historico
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params=this.aniadirFechaHistorico(params,param);
				
			strSql.append(" AND ver =(SELECT MAX (VERSION_016) FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (");
			strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') OR ");
			strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL )");
			
			params=this.aniadirFechaHistorico(params,param);
			strSql.append(" AND ACT.").append(W83bActasBD.anyoActa).append("=anoacta AND ACT.");
			strSql.append(W83bActasBD.numActa).append("=nacta AND ACT.");
			strSql.append(W83bActasBD.codTerritActa).append("=territ ");
			strSql.append(" AND ACT.").append(W83bResultadosBD.validada_016).append("=1)");
			

			if(!contar){			
				strSql.append(" GROUP BY ");
				
				strSql.append(W83bResultadosBD.nactacompleta).append(", ").append(W83bResultadosBD.nacta).append(", ").append(W83bResultadosBD.territ).append(", ").append(W83bResultadosBD.anoacta)
				.append(", ").append(W83bResultadosBD.ver).append(", ").append(W83bResultadosBD.anoregdef).append(", ").append(W83bResultadosBD.nregdef).append(", ").append(W83bResultadosBD.felec)
				.append(", ").append(W83bResultadosBD.cif).append(", ").append(W83bResultadosBD.sector).append(", ").append(W83bResultadosBD.razon).append(", ").append(W83bResultadosBD.ncentro)
				.append(", ").append(W83bResultadosBD.convdesc).append(", ").append(W83bResultadosBD.totalelectores).append(", ").append(W83bResultadosBD.sinddesc).append(", ").append(W83bResultadosBD.siglas)
				.append(", ").append(W83bResultadosBD.codsindicato);
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.nactacompleta);				
			}
			
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append(") where (rn>? AND rn<=?)");
				params.add(param.getMin());
				params.add(param.getMax());				
			}
			
//			strSql.append(" ORDER BY ");
//			strSql.append(W83bResultadosBD.nacta).append(" asc, ");
//			strSql.append(W83bResultadosBD.anoacta).append(" asc, ");
//			strSql.append(W83bResultadosBD.territ).append(" asc, ");
//			strSql.append(W83bResultadosBD.codsindicato).append(" asc");
						
		}
		
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "resCentroSindicato");
		if(contar){
			return W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83bDataBase.executeQuery(strSql.toString(),params,param.getUsuarioBean());
		}
//		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
	}

	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarCuadroResultados(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.Map buscarCuadroResultados(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		strSql.append("SELECT ");
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.anoacta).append(", ");
		strSql.append(W83bResultadosBD.ver).append(", ");
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.siglas).append(", ");
		strSql.append(W83bResultadosBD.sinddesc).append(", ");
		strSql.append(W83bResultadosBD.sinddese).append(", ");
		strSql.append(W83bResultadosBD.tipoconvenio).append(", ");
		strSql.append(W83bResultadosBD.numdelegados).append(", ");
		strSql.append(W83bResultadosBD.totalelectores).append(", ");
		strSql.append(W83bResultadosBD.cif).append(", ");
		strSql.append(W83bResultadosBD.territ).append(", TO_CHAR(");
		strSql.append(W83bResultadosBD.fechaActu).append(",'dd/MM/yyyy') ").append(W83bResultadosBD.fechaActu);
		strSql.append(" FROM TABLE (w83b.");
	    strSql.append(W83bResultadosBD.vistaCuadroResultados);
	    strSql.append("(?,?,?,?,?,?,?))");
	    if(StringUtils.isEmpty(param.getFechaHistorico())){
		    strSql.append(" where ver = (SELECT MAX (");
		    strSql.append(W83bActasBD.versionActa);
		    strSql.append(") FROM ");
		    strSql.append(W83bActasBD.actasTable);
		    strSql.append(" act WHERE ");
		    strSql.append(W83bResultadosBD.nacta);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.numActa);
		    strSql.append(" AND ");
		    strSql.append(W83bResultadosBD.anoacta);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.anyoActa);
		    strSql.append(" AND ");
		    strSql.append(W83bResultadosBD.territ);
		    strSql.append(" = act.");
		    strSql.append(W83bActasBD.codTerritActa);
		    strSql.append(" AND act.");
		    strSql.append(W83bActasBD.validada);
		    strSql.append(" = 1)");
	    }else{    	
	    	strSql.append(" dc, ");
			strSql.append(" (SELECT MAX (").append(W83bResultadosBD.VERSION_016).append(" ) AS maxver, ");
			strSql.append(W83bResultadosBD.N_ACTA_016).append(",").append(W83bResultadosBD.ANO_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.C_TERRIT_016).append(" FROM ").append(W83bResultadosBD.tabla16);
			strSql.append(" WHERE 1=1");
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"todos".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.C_TERRIT_016).append("=").append("? ");
			}
			//QUITADO POR JAVI
			//SE SUPONE EL SGTE CASO:
			//UN ACTA V0 CON FECHA DE ELECCIN DE 30/5/2012
			//SE CREA UNA INICIDENCIA Y SE CAMBIA EL 27/06/2013 (FACTU) LA FECHA DE ELECCIN A 01/06/2013
			//SACAMOS ESTE INFORME CON FECHA HISTORICO 27/05/2013 PARA QUE LA INCIDENCIA CUENTE, 
			//Y EN FECHA DE RESULTADO PONEMOS 31/05/2013
			//AL SER LA FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//Y LA VERSIN QUE CUENTA PARA ESA FECHA HISTRICO ES LA VERSIN DE LA INCIDENCIA
			//ESTE ACTA NO DEBERA SALIR. 
			//AL COGER LA QUERY QUE COGE LA MAXVERSION EL ACTA QUE COINCIDE CON  FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//CONSIDERA SOLO LA VERSIN 0
			//HE KITADO ESAS LNEAS XQ ESE FILTRO LO DEBERA HACER LA OTRA QUERY
			/*strSql.append(" AND ");
			strSql.append(W83bResultadosBD.FREGDEF_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
			strSql.append(" AND ");
			strSql.append(W83bResultadosBD.F_ELECC_016).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
			strSql.append(" AND ");
			strSql.append(W83bResultadosBD.F_ELECC_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");*/
			
			strSql.append(" AND (");
			strSql.append(W83bResultadosBD.F_BAJA_016).append(" IS NULL ");
			
			if(StringUtils.isNotEmpty(param.getFechaHistorico()))
				{
					
					strSql.append(" OR ");
					strSql.append(W83bResultadosBD.F_BAJA_016).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
					
				}
			strSql.append(" )");

			
			strSql.append(" AND (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss')");
			strSql.append(" OR ").append(W83bResultadosBD.factu_016).append(" IS NULL )");
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
			strSql.append(" GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(" ) maxresults ");
			
			strSql.append(" where DC.").append(W83bResultadosBD.nacta).append("=").append("maxresults.").append(W83bResultadosBD.N_ACTA_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83bResultadosBD.anoacta).append("=").append("maxresults.").append(W83bResultadosBD.ANO_ACTA_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83bResultadosBD.territ).append("=").append("maxresults.").append(W83bResultadosBD.C_TERRIT_016);
			strSql.append(" AND ");
			strSql.append("DC.").append(W83bResultadosBD.ver).append("=").append("maxresults.maxver");
	    }
	    
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add(param.getNumTrabajadores());
	    
	 
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    }
	    else{
	    	params.add("nohay");
	    	params.add("nohay");
	    }
	    
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"todos".equals(param.getTerritorio())){
				params.add(param.getTerritorio());
			}
			/*params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));*/
			if(StringUtils.isNotEmpty(param.getFechaHistorico()))
			{
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
		}
	    
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "cuadroResultados");
	  
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapaQuerie);
		
		String nacta="";
		String territ="";
		String anoacta="";
		int maxversion=0;
		Map mapa=new HashMap();
		Map sindicatos=new HashMap();
		Map convenios=new HashMap();
		int nd=0;
		//Date fecha=new Date();
		/*if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			fecha=W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(), "es");
		}*/
		int delegadosmenorigual49=0;
		int delegadosmayor49=0;
		if (!"todos".equals(param.getTerritorio())){
			for (int i=0;i<lista.size();i++){
				W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
				//Se cogen slo las actas de mayor versin
				if (i==0||
						((nacta.equals(res.getNacta())
								&&territ.equals(res.getTerritorio())
								&&anoacta.equals(res.getAnoacta())
								&&maxversion==Integer.parseInt(res.getVer()))
								&&StringUtils.isEmpty(param.getFechaHistorico())
								
								||
								(nacta.equals(res.getNacta())
										&&territ.equals(res.getTerritorio())
										&&anoacta.equals(res.getAnoacta())
										&&maxversion==Integer.parseInt(res.getVer()))
										&&StringUtils.isNotEmpty(param.getFechaHistorico())
										//&&(W83bDateUtil.getInstance().stringToDateIdioma(res.getFechaActualizacion(), "es").compareTo(fecha)<=0)
						)
								
								
								
					||(!nacta.equals(res.getNacta())
							||!territ.equals(res.getTerritorio())
							||!anoacta.equals(res.getAnoacta()))
					){
					//habria que mirar lo de la fecha actualizacion
					if (res.getCodsindicato()!=null&&res.getTipoconvenio()!=null){
						if (Integer.parseInt(res.getTotalelectores())>49){
							delegadosmayor49+=Integer.parseInt(res.getNumdelegados());
						}
						else{
							delegadosmenorigual49+=Integer.parseInt(res.getNumdelegados());
						}
						if (sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese())==null){
							convenios=new HashMap();//NOPMD
							convenios.put(res.getTipoconvenio(),res.getNumdelegados());
							sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
						}
						else{
							Map c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							convenios=new HashMap();//NOPMD
							convenios=c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							if (c.get(res.getTipoconvenio())!=null){
								if (res.getTipoconvenio()!=null){
									nd=Integer.parseInt((String)c.get(res.getTipoconvenio()))+Integer.parseInt(res.getNumdelegados());	
									convenios.put(res.getTipoconvenio(),String.valueOf(nd));
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
								}
							}
							else{
								convenios.put(res.getTipoconvenio(),res.getNumdelegados());
								sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
							}
						}
					}
				}
				//Hay que coger las actas de mayor versin
				//En la sql estn ordenadas por versin descendente
				if (!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta())){
					maxversion=Integer.parseInt(res.getVer());
				}
				nacta=res.getNacta();
				territ=res.getTerritorio();
				anoacta=res.getAnoacta();
		    }
		}
		else{
			Map territorios=new HashMap();
			for (int i=0;i<lista.size();i++){
				W83bResultadosBean res = (W83bResultadosBean)lista.get(i);
				if (i==0||
								
						((nacta.equals(res.getNacta())
								&&territ.equals(res.getTerritorio())
								&&anoacta.equals(res.getAnoacta())
								&&maxversion==Integer.parseInt(res.getVer()))
								&&StringUtils.isEmpty(param.getFechaHistorico())
								
								||
								(nacta.equals(res.getNacta())
										&&territ.equals(res.getTerritorio())
										&&anoacta.equals(res.getAnoacta())
										&&maxversion==Integer.parseInt(res.getVer()))
										&&StringUtils.isNotEmpty(param.getFechaHistorico())
										//&&(W83bDateUtil.getInstance().stringToDateIdioma(res.getFechaActualizacion(), "es").compareTo(fecha)<=0)
						)		
								
						//habria que mirar lo de la fecha actualizacion
						||(!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta()))){
					if (res.getCodsindicato()!=null&&res.getTipoconvenio()!=null){
						if (Integer.parseInt(res.getTotalelectores())>49){
							delegadosmayor49+=Integer.parseInt(res.getNumdelegados());
						}
						else{
							delegadosmenorigual49+=Integer.parseInt(res.getNumdelegados());
						}
						if (sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese())==null){
							convenios=new HashMap();//NOPMD
							territorios=new HashMap();//NOPMD
							territorios.put(res.getTerritorio(), res.getNumdelegados());
							convenios.put(res.getTipoconvenio(),territorios);
							sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), convenios);
						}
						else{
							Map c=(Map)sindicatos.get(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese());
							convenios=new HashMap();//NOPMD
							if (c.get(res.getTipoconvenio())!=null){
								Map t=(Map)c.get(res.getTipoconvenio());
								if (t.get(res.getTerritorio())!=null){
									nd=Integer.parseInt((String)t.get(res.getTerritorio()))+Integer.parseInt(res.getNumdelegados());
									t.put(res.getTerritorio(), String.valueOf(nd));
									c.put(res.getTipoconvenio(),t);
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
								}
								else{
									t.put(res.getTerritorio(), res.getNumdelegados());
									c.put(res.getTipoconvenio(),t);
									sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
								}
							}
							else{
								territorios=new HashMap();//NOPMD
								territorios.put(res.getTerritorio(), res.getNumdelegados());
								c.put(res.getTipoconvenio(),territorios);
								sindicatos.put(res.getSiglas()+"|"+res.getSinddesc()+"|"+res.getSinddese(), c);
							}
						}
					}
				}
				if (!nacta.equals(res.getNacta())||!territ.equals(res.getTerritorio())||!anoacta.equals(res.getAnoacta())){
					maxversion=Integer.parseInt(res.getVer());
				}
				nacta=res.getNacta();
				territ=res.getTerritorio();
				anoacta=res.getAnoacta();
		    }
		}
		mapa.put("sindicatos",sindicatos);
		mapa.put("delegadosmenorigual49", String.valueOf(delegadosmenorigual49));
		mapa.put("delegadosmayor49", String.valueOf(delegadosmayor49));
		return mapa;		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#w83bcabdelegsindconv(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List w83bcabdelegsindconv(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.totalelectores).append(", ");
		strSql.append(W83bResultadosBD.totalvotos).append(", ");
		strSql.append(W83bResultadosBD.numcentros);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bResultadosBD.w83bcabdelegsindconv);
	    strSql.append("(?,?,?,?,?,?,?))");
	    
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(param.getTerritorio());
	    params.add(param.getNumTrabajadores());
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    }
	    else{
	    	params.add("vacio");
	    	params.add("vacio");
	    }	 
		
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "cabdelegsindconv");
	    
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapaQuerie);		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!StringUtils.isNotEmpty(param.getFechaHistorico())){
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append("SELECT ");
				
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codconvenio).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.convdese).append(", ");
				strSql.append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.fecharegistro).append(" , ");
				strSql.append(W83bResultadosBD.totalvotos).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", rn");
				strSql.append(" from ( ");
				
			}
			strSql.append("SELECT "); 
			if(contar){
				strSql.append(" count(");
				strSql.append(W83bResultadosBD.nacta).append(")");
			}else{
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codconvenio).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.convdese).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(" , ");
				strSql.append(W83bResultadosBD.totalvotos).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", ");
				strSql.append("  row_number() over ( ");
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.sector).append(" asc, ");
				strSql.append(W83bResultadosBD.convdesc).append(" asc, ");
				strSql.append(W83bResultadosBD.codsindicato).append(" asc, ");
				strSql.append(W83bResultadosBD.nacta).append(",");
				strSql.append(W83bResultadosBD.territ).append(" ,");
				strSql.append(W83bResultadosBD.anoacta).append(" ,");
				strSql.append(W83bResultadosBD.ver).append(" ");
				strSql.append(") as rn");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			strSql.append(" FROM w83b.").append(W83bResultadosBD.vistaDelegadosConvenio);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.sector).append("=").append("? ");
				params.add(param.getSector());
			}
			if(StringUtils.isNotEmpty(param.getConvenio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codconvenio).append("=").append("? ");
				params.add(param.getConvenio());
			}	
			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
//				strSql.append(" OR ("); 
//				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
//				strSql.append(" AND ");  
//				strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')");
//				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
//				strSql.append(" )");
				strSql.append(") ");				
			//}
				if(!contar & !(param.getMin().equals(param.getMax()))){
					strSql.append(") where (rn>? AND rn<=?)");
					params.add(param.getMin());
					params.add(param.getMax());				
				}	
				
				
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.sector).append(" asc, ");
				strSql.append(W83bResultadosBD.convdesc).append(" asc, ");
				strSql.append(W83bResultadosBD.codsindicato).append(" asc, ");
				strSql.append(W83bResultadosBD.nacta).append(",");
				strSql.append(W83bResultadosBD.territ).append(" ,");
				strSql.append(W83bResultadosBD.anoacta).append(" ,");
				strSql.append(W83bResultadosBD.ver).append(" ");
		
		}else{
			if(!contar & !(param.getMin().equals(param.getMax()))){
				strSql.append("SELECT "); 
//				strSql.append(" VER,");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codconvenio).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.convdese).append(", ");
				strSql.append(W83bResultadosBD.felec).append(" , ");
				strSql.append(W83bResultadosBD.fecharegistro).append(" , ");
				strSql.append(W83bResultadosBD.totalvotos).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", rn");
				strSql.append(" from(");
				
			}
			strSql.append("SELECT "); 
			if(contar){
				strSql.append(" count(");
				strSql.append(W83bResultadosBD.nacta).append(")");
			}else{
//				strSql.append(" VER,");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.ncentro).append(", ");
				strSql.append(W83bResultadosBD.cif).append(", ");
				strSql.append(W83bResultadosBD.nacta).append(", ");
				strSql.append(W83bResultadosBD.anoacta).append(", ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.ver).append(", ");
				strSql.append(W83bResultadosBD.totalelectores).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.codconvenio).append(", ");
				strSql.append(W83bResultadosBD.convdesc).append(", ");
				strSql.append(W83bResultadosBD.convdese).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(" , ");
				strSql.append(W83bResultadosBD.totalvotos).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(" , ");
				strSql.append("  row_number() over ( ");
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.sector).append(" asc, ");
				strSql.append(W83bResultadosBD.convdesc).append(" asc, ");
				strSql.append(W83bResultadosBD.codsindicato).append(" asc, ");
				strSql.append(W83bResultadosBD.nacta).append(",");
				strSql.append(W83bResultadosBD.territ).append(" ,");
				strSql.append(W83bResultadosBD.anoacta).append(" ,");
				strSql.append(W83bResultadosBD.ver).append(" ");
				strSql.append(") as rn");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			strSql.append(" FROM w83b.W83BDELEGADOSPORCONVENIOHIST DC, ");
			strSql.append("(SELECT   MAX (").append(W83bResultadosBD.VERSION_016).append(") AS MAXVER, ");
			strSql.append(W83bResultadosBD.N_ACTA_016).append(",").append(W83bResultadosBD.ANO_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.C_TERRIT_016).append(" FROM ").append(W83bResultadosBD.tabla16).append(" WHERE ");
			
			//QUITADO POR JAVI
			//SE SUPONE EL SGTE CASO:
			//UN ACTA V0 CON FECHA DE ELECCIN DE 30/5/2012
			//SE CREA UNA INICIDENCIA Y SE CAMBIA EL 27/06/2013 (FACTU) LA FECHA DE ELECCIN A 01/06/2013
			//SACAMOS ESTE INFORME CON FECHA HISTORICO 27/05/2013 PARA QUE LA INCIDENCIA CUENTE, 
			//Y EN FECHA DE RESULTADO PONEMOS 31/05/2013
			//AL SER LA FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//Y LA VERSIN QUE CUENTA PARA ESA FECHA HISTRICO ES LA VERSIN DE LA INCIDENCIA
			//ESTE ACTA NO DEBERA SALIR. 
			//AL COGER LA QUERY QUE COGE LA MAXVERSION EL ACTA QUE COINCIDE CON  FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
			//CONSIDERA SOLO LA VERSIN 0
			//HE KITADO ESAS LNEAS XQ ESE FILTRO LO DEBERA HACER LA OTRA QUERY
			/*if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.FREGDEF_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}*/
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				//strSql.append(" AND ");
				strSql.append(W83bResultadosBD.C_TERRIT_016).append("=").append("? ");
				params.add(param.getTerritorio());
				strSql.append(" AND ");				
			}
			
			
			strSql.append("  (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss') OR ");
			strSql.append(W83bResultadosBD.factu_016).append(" IS NULL )");
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
			strSql.append("GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(") MAXRESULTS");
			
			strSql.append(" WHERE ");
			
			strSql.append(" DC.NACTA = MAXRESULTS.").append(W83bResultadosBD.N_ACTA_016 );
			strSql.append(" AND DC.ANOACTA = MAXRESULTS.").append(W83bResultadosBD.ANO_ACTA_016 );
			strSql.append(" AND DC.TERRIT = MAXRESULTS.").append(W83bResultadosBD.C_TERRIT_016 );
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(" AND ");
				strSql.append("DC.FECHAREGISTRO").append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append("DC.FELEC").append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append("DC.FELEC").append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append("DC.TERRIT").append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.sector).append("=").append("? ");
				params.add(param.getSector());
			}
			if(StringUtils.isNotEmpty(param.getConvenio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codconvenio).append("=").append("? ");
				params.add(param.getConvenio());
			}
			strSql.append(" AND ");
			strSql.append("DC.VER").append("=").append("MAXRESULTS.MAXVER ");
			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) ");  
			//}
				if(!contar & !(param.getMin().equals(param.getMax()))){
					strSql.append(") where (rn>? AND rn<=?)");
					params.add(param.getMin());
					params.add(param.getMax());				
				}	
				
				strSql.append(" ORDER BY ");
				strSql.append(W83bResultadosBD.sector).append(" asc, ");
				strSql.append(W83bResultadosBD.convdesc).append(" asc, ");
				strSql.append(W83bResultadosBD.codsindicato).append(" asc, ");
				strSql.append(W83bResultadosBD.nacta).append(",");
				strSql.append(W83bResultadosBD.territ).append(" ,");
				strSql.append(W83bResultadosBD.anoacta).append(" ,");
				strSql.append(W83bResultadosBD.ver).append(" ");
				
			
		}
		
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "delegadosPorConvenio");
			
		if(contar){
			return W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(),mapa );			
		}
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarRepresentantesCandTamEmp(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarRepresentantesCandTamEmp(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
			StringBuffer strSql = new StringBuffer();//NOPMD
			List params = new ArrayList();
			if(!StringUtils.isNotEmpty(param.getFechaHistorico())){
				strSql.append("SELECT "); 
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.codprovincia).append(", ");
				strSql.append(W83bResultadosBD.codmunicipio).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.numtrabajadores).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaRepresentanteCandTamEmp);
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
//				strSql=this.aniadirFechaBaja(strSql,param);
//				params=this.aniadirFechaBaja(params,param);
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
				strSql.append(") ");
				
			}else{
				strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
				strSql.append("SELECT ");
				strSql.append(W83bResultadosBD.territ).append(", ");
				strSql.append(W83bResultadosBD.codprovincia).append(", ");
				strSql.append(W83bResultadosBD.codmunicipio).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.numtrabajadores).append(", ");
				strSql.append(W83bResultadosBD.numdelegados).append(", ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
				strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro);
				strSql.append(" FROM ").append(W83bResultadosBD.w83brepresentcandtamemprhist).append(" dc, ");
				strSql.append(" (SELECT MAX (").append(W83bResultadosBD.VERSION_016).append(" ) AS maxver, ");
				strSql.append(W83bResultadosBD.N_ACTA_016).append(",").append(W83bResultadosBD.ANO_ACTA_016).append(",");
				strSql.append(W83bResultadosBD.C_TERRIT_016).append(" FROM ").append(W83bResultadosBD.tabla16);
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.C_TERRIT_016).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				//QUITADO POR JAVI
				//SE SUPONE EL SGTE CASO:
				//UN ACTA V0 CON FECHA DE ELECCIN DE 30/5/2012
				//SE CREA UNA INICIDENCIA Y SE CAMBIA EL 27/06/2013 (FACTU) LA FECHA DE ELECCIN A 01/06/2013
				//SACAMOS ESTE INFORME CON FECHA HISTORICO 27/05/2013 PARA QUE LA INCIDENCIA CUENTE, 
				//Y EN FECHA DE RESULTADO PONEMOS 31/05/2013
				//AL SER LA FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
				//Y LA VERSIN QUE CUENTA PARA ESA FECHA HISTRICO ES LA VERSIN DE LA INCIDENCIA
				//ESTE ACTA NO DEBERA SALIR. 
				//AL COGER LA QUERY QUE COGE LA MAXVERSION EL ACTA QUE COINCIDE CON  FECHA DE ELECCIN ENTRE 01/06/2009 - 31/05/2013
				//CONSIDERA SOLO LA VERSIN 0
				//HE KITADO ESAS LNEAS XQ ESE FILTRO LO DEBERA HACER LA OTRA QUERY
				/*strSql.append(" AND ");
				strSql.append(W83bResultadosBD.FREGDEF_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.F_ELECC_016).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));*/
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.F_BAJA_016).append(" IS NULL ");
				
				if(StringUtils.isNotEmpty(param.getFechaHistorico()))
					{
						
						strSql.append(" OR ");
						strSql.append(W83bResultadosBD.F_BAJA_016).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
						
					}
				strSql.append(" )");
				if(StringUtils.isNotEmpty(param.getFechaHistorico()))
				{
					params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				}
				
				strSql.append(" AND (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss')");
				strSql.append(" OR ").append(W83bResultadosBD.factu_016).append(" IS NULL )");
				strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
				strSql.append(" GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
				strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(" ) maxresults ");
				
				strSql.append(" WHERE ");
				
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
				strSql=this.aniadirFechaBaja(strSql,param);
				params=this.aniadirFechaBaja(params,param);
				
				strSql.append(" AND DC.").append(W83bResultadosBD.nacta).append("=").append("maxresults.").append(W83bResultadosBD.N_ACTA_016);
				strSql.append(" AND ");
				strSql.append("DC.").append(W83bResultadosBD.anoacta).append("=").append("maxresults.").append(W83bResultadosBD.ANO_ACTA_016);
				strSql.append(" AND ");
				strSql.append("DC.").append(W83bResultadosBD.territ).append("=").append("maxresults.").append(W83bResultadosBD.C_TERRIT_016);
				strSql.append(" AND ");
				strSql.append("DC.").append(W83bResultadosBD.ver).append("=").append("maxresults.maxver");
				
				
			}	
			
			HashMap mapa = new HashMap();
			mapa.put("idioma", param.getIdioma());
			mapa.put("querie", "representantesCandTamEmp");
			
				return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
		
	}
	public java.util.List buscarResultadosPorSectorSindicato(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
			List params = new ArrayList();
			if(StringUtils.isEmpty(param.getFechaHistorico())){
				strSql.append("SELECT "); 
				
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese).append(", SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(") AS ").append(W83bResultadosBD.numdelegadosM).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosH).append(") AS ").append(W83bResultadosBD.numdelegadosH).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(")+ SUM(").append(W83bResultadosBD.numdelegadosH).append(" ) AS ").append(W83bResultadosBD.numdelegados);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadosPorSectorSindicato);
				strSql.append(" WHERE ");
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}else{
					strSql.append(W83bResultadosBD.territ).append(" IN (?, ?, ? ) ");
					params.add(W83bClsConstantes.CONSTANTE_ALAVA);
					params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
					params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
				}
				
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
//				strSql=this.aniadirFechaBaja(strSql,param);
//				params=this.aniadirFechaBaja(params,param);
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
				strSql.append(") ");
				
				
				strSql=this.aniadirSector(strSql,param);
				params=this.aniadirSector(params,param);
				
				strSql.append(" GROUP BY ");
				strSql.append("tabla").append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese);
			}
			else{
				
				strSql.append("SELECT "); 
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese).append(", SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(") AS ").append(W83bResultadosBD.numdelegadosM).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosH).append(") AS ").append(W83bResultadosBD.numdelegadosH).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(")+ SUM(").append(W83bResultadosBD.numdelegadosH).append(" ) AS ").append(W83bResultadosBD.numdelegados);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadosPorSectorSindicatoHis);
				strSql.append(" WHERE ");
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}else{
					strSql.append(W83bResultadosBD.territ).append(" IN (?, ?, ? ) ");
					params.add(W83bClsConstantes.CONSTANTE_ALAVA);
					params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
					params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
				}
				
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
				strSql=this.aniadirFechaBaja(strSql,param);
				params=this.aniadirFechaBaja(params,param);
				
				strSql=this.aniadirSector(strSql,param);
				params=this.aniadirSector(params,param);
				strSql.append(" AND VERS =(SELECT MAX (ACT. ").append(W83bActasBD.versionActa);
				strSql.append(") FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (");
				strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') OR ");
				strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL) ");
				
				params=this.aniadirFechaHistorico(params,param);
				strSql.append(" AND ACT.").append(W83bActasBD.anyoActa).append("=ANOACTA AND ACT.");
				strSql.append(W83bActasBD.numActa).append("=NUMACTA AND ACT.");
				strSql.append(W83bActasBD.codTerritActa).append("=TERRIT ");
				strSql.append(" AND ACT.").append(W83bResultadosBD.validada_016).append("=1)");
								
				strSql.append(" GROUP BY ");
				strSql.append("tabla").append(", ");
				strSql.append(W83bResultadosBD.sector).append(", ");
				strSql.append(W83bResultadosBD.descsector).append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese);
			}
			
			
			
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), param.getIdioma());
	
}
	public java.util.List buscarResultadosPorSectorSindicatoTotales(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
			List params = new ArrayList();
			if(StringUtils.isEmpty(param.getFechaHistorico())){
				strSql.append("SELECT "); 
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese).append(", SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(") AS ").append(W83bResultadosBD.numdelegadosM).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosH).append(") AS ").append(W83bResultadosBD.numdelegadosH).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(")+ SUM(").append(W83bResultadosBD.numdelegadosH).append(" ) AS ").append(W83bResultadosBD.numdelegados);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadosPorSectorSindicato);
				strSql.append(" WHERE ");
				if(StringUtils.isEmpty(param.getTerritorio())
						|| "null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append(" IN (?, ?, ? ) ");
					params.add(W83bClsConstantes.CONSTANTE_ALAVA);
					params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
					params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
				}else{
					strSql.append(W83bResultadosBD.territ).append(" = ? ");
					params.add(param.getTerritorio());					
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
//				strSql=this.aniadirFechaBaja(strSql,param);
//				params=this.aniadirFechaBaja(params,param);
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
				strSql.append(") ");
				
				strSql=this.aniadirSector(strSql,param);
				params=this.aniadirSector(params,param);
				strSql.append(" AND ").append(W83bResultadosBD.codsindicato).append(" IS NOT NULL ");
				strSql.append(" GROUP BY ");
				strSql.append("tabla").append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese);
				strSql.append(" ORDER BY ").append(W83bResultadosBD.codsindicato);
			}
			else{
				strSql.append("SELECT "); 
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese).append(", SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(") AS ").append(W83bResultadosBD.numdelegadosM).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosH).append(") AS ").append(W83bResultadosBD.numdelegadosH).append(" , SUM(");
				strSql.append(W83bResultadosBD.numdelegadosM).append(")+ SUM(").append(W83bResultadosBD.numdelegadosH).append(" ) AS ").append(W83bResultadosBD.numdelegados);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadosPorSectorSindicatoHis);
				strSql.append(" WHERE ");
				if(StringUtils.isEmpty(param.getTerritorio())
						|| "null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append(" IN (?, ?, ? ) ");
					params.add(W83bClsConstantes.CONSTANTE_ALAVA);
					params.add(W83bClsConstantes.CONSTANTE_BIZKAIA);
					params.add(W83bClsConstantes.CONSTANTE_GIPUZKOA);
				}else{
					strSql.append(W83bResultadosBD.territ).append(" = ? ");
					params.add(param.getTerritorio());					
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
				strSql=this.aniadirFechaBaja(strSql,param);
				params=this.aniadirFechaBaja(params,param);
				
				strSql=this.aniadirSector(strSql,param);
				params=this.aniadirSector(params,param);
				strSql.append(" AND VERS =(SELECT MAX (act.").append(W83bActasBD.versionActa).append(") FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (");
				strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				strSql.append(" or ").append(W83bActasBD.fechaActualizacion).append(" is null)");
//				strSql=this.aniadirFechaHistorico(strSql);
				params=this.aniadirFechaHistorico(params,param);
				strSql.append(" AND ACT.").append(W83bActasBD.anyoActa).append("=ANOACTA AND ACT.");
				strSql.append(W83bActasBD.numActa).append("=NUMACTA AND ACT.");
				strSql.append(W83bActasBD.codTerritActa).append("=TERRIT AND ACT.");
				strSql.append(W83bActasBD.validada).append("= ? )");
				params.add(W83bClsConstantes.CONSTANTE_VALIDADA);
				strSql.append(" AND ").append(W83bResultadosBD.codsindicato).append(" IS NOT NULL ");
				strSql.append(" GROUP BY ");
				strSql.append("tabla").append(", ");
				strSql.append(W83bResultadosBD.codsindicato).append(", ");
				strSql.append(W83bResultadosBD.siglas).append(", ");
				strSql.append(W83bResultadosBD.sinddesc).append(", ");
				strSql.append(W83bResultadosBD.sinddese);
				strSql.append(" ORDER BY ").append(W83bResultadosBD.codsindicato);
			}
			
			
			
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), param.getIdioma());
	
}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarRepresentantesCandTamEmp(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarDiferenciasPorConvenio(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
			StringBuffer strSql = new StringBuffer();//NOPMD
			List params = new ArrayList();
			if(StringUtils.isEmpty(param.getFechaHistorico())){
				
				strSql.append("SELECT "); 
				strSql=rellenarCamposSelectComunes(strSql);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaDiferenciasPorConvenio);
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
			
				strSql=this.aniadirNumActa(strSql);
				params=this.aniadirNumActa(params,param);
//				strSql=this.aniadirFechaBaja(strSql,param);
//				params=this.aniadirFechaBaja(params,param);
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
				strSql.append(") ");
				//fin NMERO DE ACTA
				strSql=this.aniadirConvenio(strSql,param);
				params=this.aniadirConvenio(params,param);
}
			else{
				strSql.append("SELECT "); 
				strSql=rellenarCamposSelectComunes(strSql);
				strSql.append(" ,VERS,ANOACTA,ACTA ");
				strSql.append(" FROM ").append(W83bResultadosBD.vistaDiferenciasPorConvenioHist);
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
			
				strSql=this.aniadirNumActa(strSql);
				params=this.aniadirNumActa(params,param);
				strSql=this.aniadirFechaBaja(strSql,param);
				params=this.aniadirFechaBaja(params,param);
				//fin NMERO DE ACTA
				strSql=this.aniadirConvenio(strSql,param);
				params=this.aniadirConvenio(params,param);
				strSql.append(" AND VERS =(SELECT MAX (ACT.");
				strSql.append(W83bActasBD.versionActa);
				strSql.append(") FROM ").append(W83bActasBD.actasTable).append(" ACT WHERE (ACT.");
				strSql.append(W83bActasBD.fechaActualizacion).append("<=TO_DATE(?,?) OR ACT.");
				strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL) AND ACT.");
				strSql.append(W83bActasBD.anyoActa).append("=ANOACTA AND ACT.");
				strSql.append(W83bActasBD.numActa).append("=ACTA AND ACT.");
				strSql.append(W83bActasBD.codTerritActa).append("=TERRIT ");
				strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1)");
				params.add(param.getFeHist());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
					
			}

			
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "diferenciasPorConvenio");
				
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
		
	}
	
	/**
	 * Rellenar campos select comunes.
	 *
	 * @param strsqlparam the strsqlparam
	 * @return the string buffer
	 */
	private StringBuffer rellenarCamposSelectComunes(StringBuffer strsqlparam)
	{
		StringBuffer strSql=strsqlparam;
		strSql.append(W83bResultadosBD.territ).append(", ");
		strSql.append(W83bResultadosBD.codprovincia).append(", ");
		strSql.append(W83bResultadosBD.codmunicipio).append(", ");
		strSql.append(W83bResultadosBD.nregistro).append(", ");
		strSql.append(W83bResultadosBD.codcnae).append(", ");
		strSql.append(W83bResultadosBD.nacta).append(", ");
		strSql.append(W83bResultadosBD.totalelectores).append(", ");
		strSql.append(W83bResultadosBD.codconvenio).append(", ");
		strSql.append(W83bResultadosBD.descconvenio).append(", ");
		strSql.append(W83bResultadosBD.deseconvenio).append(", ");
		strSql.append(W83bResultadosBD.codsindicato).append(", ");
		strSql.append(W83bResultadosBD.siglas).append(", ");
		strSql.append(W83bResultadosBD.codcolegio).append(", ");
		strSql.append(W83bResultadosBD.adminemp).append(", ");
		strSql.append(W83bResultadosBD.numdelegados).append(", ");
		strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
		strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro);
		return strSql;
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarRepresentantesCandTamEmp(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarResulPorEscrutinio(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
			
			StringBuffer strSql = new StringBuffer();//NOPMD
			List params = new ArrayList();
			if(!StringUtils.isNotEmpty(param.getFechaHistorico())){	
				strSql.append("SELECT ");
				strSql.append(W83bResultadosBD.votos).append(", ");
				strSql=rellenarCamposSelectComunes(strSql);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaEscrutiniosPorConvenio);
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
//				strSql=this.aniadirFechaBaja(strSql,param);
//				params=this.aniadirFechaBaja(params,param);
				strSql.append(" AND (");
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
				strSql.append(") ");
				
				strSql=this.aniadirNumActa(strSql);
				params=this.aniadirNumActa(params,param);
				//fin NMERO DE ACTA
				strSql=this.aniadirConvenio(strSql,param);
				params=this.aniadirConvenio(params,param);
			}else{
				strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
				strSql.append("SELECT ");
				strSql.append(W83bResultadosBD.votos).append(", ");
				strSql=rellenarCamposSelectComunes(strSql);
				strSql.append(" FROM ").append(W83bResultadosBD.vistaEscrutiniosPorConveniohist).append(" dc ");
				strSql.append(" WHERE ");
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
					strSql.append(W83bResultadosBD.territ).append("=").append("? ");
					params.add(param.getTerritorio());
				}
				strSql=this.aniadirGrupoFechas(strSql);
				params=this.aniadirGrupoFechas(params,param);
				strSql=this.aniadirFechaBaja(strSql,param);
				params=this.aniadirFechaBaja(params,param);
				
				strSql=this.aniadirNumActa(strSql);
				params=this.aniadirNumActa(params,param);
				//fin NMERO DE ACTA
				strSql=this.aniadirConvenio(strSql,param);
				params=this.aniadirConvenio(params,param);
				
				strSql.append(" AND ").append(W83bResultadosBD.ver).append("=");
				strSql.append("(SELECT MAX(").append(W83bResultadosBD.VERSION_016).append(") AS vermax FROM ");
				strSql.append(W83bResultadosBD.tabla16).append(" WHERE dc.").append(W83bResultadosBD.acta);
				strSql.append("=").append(W83bResultadosBD.N_ACTA_016).append(" AND  dc.").append(W83bResultadosBD.ano);
				strSql.append("=").append(W83bResultadosBD.ANO_ACTA_016).append(" AND  dc.").append(W83bResultadosBD.territ);
				strSql.append("=").append(W83bResultadosBD.C_TERRIT_016).append(" AND (").append(W83bResultadosBD.factu_016);
				strSql.append("<= TO_DATE ('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59', 'dd/MM/yyyy hh24:mi:ss') ");
				strSql.append(" OR ").append(W83bResultadosBD.factu_016).append(" IS NULL) ");
				strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1 )");
				
			}	
			
			
			HashMap mapa = new HashMap();
			mapa.put("idioma", param.getIdioma());
			mapa.put("querie", "escrutinioPorConvenio");
			
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
				
	}
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarResultadosSexo(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarResultadosSexo(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT TACT.");
		strSql.append(W83bActasBD.numActa).append(", TACT.");
		strSql.append(W83bActasBD.anyoActa).append(", TACT.");
		strSql.append(W83bActasBD.codTerritActa).append(", TACT.");
		strSql.append(W83bActasBD.versionActa).append(", ");
		strSql.append("TO_CHAR(").append(W83bActasBD.fechaEleccion).append(",?) AS ").append(W83bActasBD.fechaEleccion).append(" , ");
		strSql.append("TO_CHAR(").append(W83bActasBD.fecRegDefinitivo).append(",?) AS ").append(W83bActasBD.fecRegDefinitivo).append(" , TACT.");
		strSql.append(W83bActasBD.nElectoresHombre).append(", TACT.");
		strSql.append(W83bActasBD.nElectoresMujer).append(", TACT.");
		strSql.append(W83bActasBD.totalElectores).append(", TACT.");
		strSql.append(W83bActasBD.nCandidatosHombre).append(", TACT.");
		strSql.append(W83bActasBD.nCandidatosMujer).append(", PROV.");
		strSql.append(W83bResultadosBD.dso);
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" TACT,");
		strSql.append(W83bResultadosBD.tablaprovincia).append(" PROV ");
		strSql.append(" WHERE ");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		
		strSql.append(" TACT.");
		strSql.append(W83bActasBD.fechaEleccion).append(" IS NOT NULL ");
		strSql.append(" AND TACT.");
		strSql.append(W83bActasBD.fecRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND TACT.");
		strSql.append(W83bActasBD.numRegDefinitivo).append(" IS NOT NULL ");
		strSql.append(" AND TACT.");
		strSql.append(W83bActasBD.fechaBaja).append(" IS NULL ");
		strSql.append(" AND TACT.");
		strSql.append(W83bActasBD.numTotalActa).append(" IS NULL ");
		//Controlo que cojo las actas con la ltima versin validada
		strSql.append(" AND TACT.");
		strSql.append(W83bActasBD.versionActa).append(" = (");
		strSql.append("SELECT MAX(TVER.");
		strSql.append(W83bActasBD.versionActa).append(")");
		strSql.append(" FROM ").append(W83bActasBD.actasTable).append(" TVER");
		strSql.append(" WHERE TACT.");
		strSql.append(W83bActasBD.numActa).append(" = TVER.").append(W83bActasBD.numActa).append(" AND TACT.");
		strSql.append(W83bActasBD.anyoActa).append(" = TVER.").append(W83bActasBD.anyoActa).append(" AND TACT.");
		strSql.append(W83bActasBD.codTerritActa).append(" = TVER.").append(W83bActasBD.codTerritActa).append(" AND TVER.");
		strSql.append(W83bActasBD.validada).append(" = ").append(W83bClsConstantes.UNO);
		if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			strSql.append(" AND ( TVER.");
			strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFeHist());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" OR ");
			strSql.append(W83bActasBD.fechaActualizacion).append(" IS NULL) ");

			strSql.append(") AND (TACT.");
			strSql.append(W83bActasBD.fechaBaja).append(" IS NULL OR TACT.");
			strSql.append(W83bActasBD.fechaBaja).append(" >TO_DATE(?,?))");
			params.add(param.getFechaEleccionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}else{
			strSql.append(") AND (TACT.");
			strSql.append(W83bActasBD.fechaBaja).append(" IS NULL)");			
		}
		if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
			strSql.append(" AND TACT.");
			strSql.append(W83bActasBD.fecRegDefinitivo).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaRegistroDefinitivo());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
			strSql.append(" AND TACT.");
			strSql.append(W83bActasBD.fechaEleccion).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEleccionDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND TACT.");
			strSql.append(W83bActasBD.fechaEleccion).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEleccionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		strSql.append(" AND TACT.").append(W83bActasBD.codTerritActa).append("=PROV.").append(W83bResultadosBD.id);
		strSql.append(" AND TACT.").append(W83bResultadosBD.validada_016).append("=1");
		if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
			strSql.append(" AND TACT.");
			strSql.append(W83bActasBD.codTerritActa).append("=").append("? ");
			params.add(param.getTerritorio());
		}
		
		strSql.append(" ORDER BY TACT.").append(W83bActasBD.codTerritActa).append(", TACT.").append(W83bActasBD.numActa).append(", TACT.").append(W83bActasBD.anyoActa).append(", TACT.").append(W83bActasBD.versionActa);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bActasBean.class,param.getUsuarioBean(), "RESULTADOSPORSEXO");
		
		return lista;
	}
	
	public List buscarResultadosPorSexo(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		
		strSql.append("SELECT vista.");
		strSql.append(W83bResultadosBD.NACTA).append(", vista.");
		strSql.append(W83bResultadosBD.TERRIT).append(", vista.");
		strSql.append(W83bResultadosBD.ANOACTA).append(", vista.");
		strSql.append(W83bResultadosBD.VER).append(", ");
		strSql.append("TO_CHAR(vista.").append(W83bResultadosBD.FELEC).append(",?) AS ").append(W83bResultadosBD.FELEC).append(" , ");
		strSql.append("TO_CHAR(vista.").append(W83bResultadosBD.FECHAREGISTRO).append(",?) AS ").append(W83bResultadosBD.FECHAREGISTRO).append(" , vista.");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		strSql.append(W83bResultadosBD.ELECTORESH).append(", vista.");
		strSql.append(W83bResultadosBD.ELECTORESM).append(", vista.");
		strSql.append(W83bResultadosBD.TOTALELECTORES).append(", vista.");
		strSql.append(W83bResultadosBD.NCANDIDATOSH).append(", vista.");
		strSql.append(W83bResultadosBD.NCANDIDATOSM).append(", vista.");
		strSql.append(W83bResultadosBD.DSPROVINCIA).append(", nvl(sum(vista.");
		strSql.append(W83bResultadosBD.SUMDELEGADOSH).append("),'0') as ").append(W83bResultadosBD.SUMDELEGADOSH);
		strSql.append(", nvl(sum(vista.");
		strSql.append(W83bResultadosBD.SUMDELEGADOSM).append("),'0') as ").append(W83bResultadosBD.SUMDELEGADOSM);
		strSql.append(", nvl(sum(vista.");
		strSql.append(W83bResultadosBD.SUMDELEGADOS).append("),'0') as ").append(W83bResultadosBD.SUMDELEGADOS);
		strSql.append("");
		
		strSql.append(" FROM ").append(W83bResultadosBD.vistaResultadosPorSexo).append(" vista ");
		strSql.append(" WHERE ");
		
		
		if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			strSql.append(" ").append(W83bResultadosBD.VER).append("=");
			strSql.append("(SELECT MAX(").append(W83bResultadosBD.VERSION_016).append(") AS vermax FROM ");
			strSql.append(W83bResultadosBD.tabla16).append(" WHERE vista.").append(W83bResultadosBD.NACTA);
			strSql.append("=").append(W83bResultadosBD.N_ACTA_016).append(" AND  vista.").append(W83bResultadosBD.ANOACTA);
			strSql.append("=").append(W83bResultadosBD.ANO_ACTA_016).append(" AND  vista.").append(W83bResultadosBD.TERRIT);
			strSql.append("=").append(W83bResultadosBD.C_TERRIT_016).append(" AND (").append(W83bResultadosBD.factu_016);
			strSql.append("<= TO_DATE (?, ?) OR  ").append(W83bResultadosBD.factu_016).append(" IS NULL ) ");
			params.add(param.getFeHist());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1 )");
		}else{
			strSql.append(" vista.").append(W83bResultadosBD.VER).append("=");
			strSql.append("(SELECT MAX(").append(W83bResultadosBD.VERSION_016).append(") AS vermax FROM ");
			strSql.append(W83bResultadosBD.tabla16).append(" WHERE vista.").append(W83bResultadosBD.NACTA);
			strSql.append("=").append(W83bResultadosBD.N_ACTA_016).append(" AND  vista.").append(W83bResultadosBD.ANOACTA);
			strSql.append("=").append(W83bResultadosBD.ANO_ACTA_016).append(" AND  vista.").append(W83bResultadosBD.TERRIT);
			strSql.append("=").append(W83bResultadosBD.C_TERRIT_016);
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1 )");			
		}
		
		if(StringUtils.isNotEmpty(param.getFechaHistorico())){
			strSql.append(" AND (vista.");
			strSql.append(W83bResultadosBD.FECHAACTUALIZACION).append("<=").append("TO_DATE(?,?) OR ");
			strSql.append(W83bResultadosBD.FECHAACTUALIZACION).append(" IS NULL) ");
			params.add(param.getFeHist());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND (vista."); 
				strSql.append(W83bResultadosBD.FECHABAJA).append(" IS NULL");
				strSql.append(" OR (vista."); 
				strSql.append(W83bResultadosBD.FECHABAJA).append(" IS NOT NULL");
				strSql.append(" AND vista.");  
				strSql.append(W83bResultadosBD.FECHABAJA).append(" > ").append("TO_DATE(?, ?)");
				params.add(param.getFechaHistorico());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				strSql.append(" )) ");  
			//}
		}else{
			strSql.append(" AND (vista."); 
			strSql.append(W83bResultadosBD.FECHABAJA).append(" IS NULL");
			strSql.append(") "); 
			
		}
		
		
		if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
			strSql.append(" AND vista.");
			strSql.append(W83bResultadosBD.FECHAREGISTRO).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaRegistroDefinitivo());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
			strSql.append(" AND vista.");
			strSql.append(W83bResultadosBD.FECHAELEC).append(">=").append("TO_DATE(?,?)");
			params.add(param.getFechaEleccionDesde());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
			strSql.append(" AND vista.");
			strSql.append(W83bResultadosBD.FECHAELEC).append("<=").append("TO_DATE(?,?)");
			params.add(param.getFechaEleccionHasta());
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
			strSql.append(" AND vista.");
			strSql.append(W83bResultadosBD.TERRIT).append("=").append("? ");
			params.add(param.getTerritorio());
		}
		

		strSql.append("group by vista.");
		strSql.append(W83bResultadosBD.NACTA).append(", vista.");
		strSql.append(W83bResultadosBD.TERRIT).append(", vista.");
		strSql.append(W83bResultadosBD.ANOACTA).append(", vista.");
		strSql.append(W83bResultadosBD.VER).append(", ");
		strSql.append("vista.").append(W83bResultadosBD.FELEC).append(" , ");
		strSql.append("vista.").append(W83bResultadosBD.FECHAREGISTRO).append(" , vista.");
		strSql.append(W83bResultadosBD.ELECTORESH).append(", vista.");
		strSql.append(W83bResultadosBD.ELECTORESM).append(", vista.");
		strSql.append(W83bResultadosBD.TOTALELECTORES).append(", vista.");
		strSql.append(W83bResultadosBD.NCANDIDATOSH).append(", vista.");
		strSql.append(W83bResultadosBD.NCANDIDATOSM).append(", vista.");
		strSql.append(W83bResultadosBD.DSPROVINCIA);
		
		strSql.append(" ORDER BY vista.").append(W83bResultadosBD.TERRIT).append(", vista.").append(W83bResultadosBD.NACTA).append(", vista.").append(W83bResultadosBD.ANOACTA).append(", vista.").append(W83bResultadosBD.VER);
		
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "resultadosPorSexo");
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
		
		return lista;	
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarActaEnEscrutinio(w83b.w83bBeans.W83bActasBean)
	 */
	public W83bEscrutinioBean buscarActaEnEscrutinio(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT TESC.");		
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(", SUM(TESC.");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(") AS ").append(W83bEscrutiniosBD.delegadosHombres).append(", SUM(TESC.");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(") AS ").append(W83bEscrutiniosBD.delegadosMujeres);
		
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista).append(" TESC");
		
		strSql.append(" WHERE ");
		strSql.append(" TESC.");
		strSql.append(W83bEscrutiniosBD.acta).append(" = ").append("? ");
		params.add(param.getNumActa());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(" = ").append("? ");
		params.add(param.getAnyoActaTotal());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(" = ").append("? ");
		params.add(param.getTerritorioActaTotal());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.versionActa).append(" = ").append("? ");
		params.add(param.getVersion());
				
		strSql.append(" GROUP BY TESC.").append(W83bEscrutiniosBD.codigoColegio);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bEscrutinioBean.class,param.getUsuarioBean(), null);
		
		if(!lista.isEmpty()){
			if(lista.size()>1){
				Iterator itEsc = lista.iterator();
				int repreH=0;
				int repreM=0;
				while(itEsc.hasNext()){
					W83bEscrutinioBean current = (W83bEscrutinioBean) itEsc.next();
					repreH = repreH +Integer.parseInt(current.getDelegadosHombres());
		            repreM = repreM +Integer.parseInt(current.getDelegadosMujeres());
				}
				W83bEscrutinioBean bean =(W83bEscrutinioBean)lista.get(0);
				bean.setDelegadosHombres(repreH+"");
				bean.setDelegadosMujeres(repreM+"");
				return bean;
			}else{
				return (W83bEscrutinioBean)lista.get(0);
			}
		}else{
			return null;
		}
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarActaEnEscrutinio(w83b.w83bBeans.W83bActasBean)
	 */
	public W83bDiferenciasBean buscarActaEnDiferencias(w83b.w83bBeans.W83bActasBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT TDIF.");		
		strSql.append(W83bDiferenciasBD.codigoColegio).append(", SUM(TDIF.");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(") AS ").append(W83bDiferenciasBD.delegadosHombres).append(", SUM(TDIF.");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(") AS ").append(W83bDiferenciasBD.delegadosMujeres);
		
		strSql.append(" FROM ").append(W83bDiferenciasBD.difVista).append(" TDIF");
		
		strSql.append(" WHERE ");
		strSql.append(" TDIF.");
		strSql.append(W83bDiferenciasBD.acta).append(" = ").append("? ");
		params.add(param.getNumActa());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.anyoActa).append(" = ").append("? ");
		params.add(param.getAnyoActaTotal());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.territorioActa).append(" = ").append("? ");
		params.add(param.getTerritorioActaTotal());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.versionActa).append(" = ").append("? ");
		params.add(param.getVersion());
		
		strSql.append(" GROUP BY TDIF.").append(W83bDiferenciasBD.codigoColegio);
		
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bDiferenciasBean.class,param.getUsuarioBean(), null);
		
		if(!lista.isEmpty()){
			if(lista.size()>1){
				Iterator itEsc = lista.iterator();
				int repreH=0;
				int repreM=0;
				while(itEsc.hasNext()){
					W83bDiferenciasBean current = (W83bDiferenciasBean) itEsc.next();
					repreH = repreH +Integer.parseInt(current.getNumDelegadosHombres());
					repreM = repreM +Integer.parseInt(current.getNumDelegadosMujeres());
				}
				W83bDiferenciasBean bean =(W83bDiferenciasBean)lista.get(0);
				bean.setNumDelegadosHombres(repreH+"");
				bean.setNumDelegadosMujeres(repreM+"");
				return bean;
			}else{
				return (W83bDiferenciasBean)lista.get(0);
			}
		}else{
			return null;
		}
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarDelegadosConvenio(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List buscarDelegConvDetCentro(w83b.w83bBeans.W83bResultadosBean param,boolean contar) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append("SELECT ");
			
			strSql.append(W83bResultadosBD.sector).append(", ");
			strSql.append(W83bResultadosBD.descsector).append(", ");
			strSql.append(W83bResultadosBD.ncentro).append(", ");
			strSql.append(W83bResultadosBD.cif).append(", ").append(W83bResultadosBD.razon).append(", ").append(W83bResultadosBD.nacta).append(", ");
			strSql.append(W83bResultadosBD.anoacta).append(", ").append(W83bResultadosBD.territ).append(", ").append(W83bResultadosBD.ver).append(", ");
			strSql.append(W83bResultadosBD.totalelectores).append(", ").append(W83bResultadosBD.codsindicato).append(", ");
			strSql.append(W83bResultadosBD.siglas).append(", ").append(W83bResultadosBD.codconvenio).append(", ");
			strSql.append(W83bResultadosBD.convdesc).append(", ").append(W83bResultadosBD.convdese).append(", ");
			strSql.append(W83bResultadosBD.felec).append(" , ");
			strSql.append(W83bResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83bResultadosBD.totalvotos).append(", ");
			strSql.append(W83bResultadosBD.numdelegados).append(", ");
			strSql.append(W83bResultadosBD.nactacompleta).append(", rn");
			strSql.append(" from ( ");
			
		}
		strSql.append("SELECT "); 
		if(contar){
			strSql.append(" count(");
			strSql.append(W83bResultadosBD.nacta).append(")");
		}else{
			strSql.append(W83bResultadosBD.sector).append(", ");
			strSql.append(W83bResultadosBD.descsector).append(", ");
			strSql.append(W83bResultadosBD.ncentro).append(", ");
			strSql.append(W83bResultadosBD.cif).append(", ").append(W83bResultadosBD.razon).append(", ").append(W83bResultadosBD.nacta).append(", ");
			strSql.append(W83bResultadosBD.anoacta).append(", ").append(W83bResultadosBD.territ).append(", ").append(W83bResultadosBD.ver).append(", ");
			strSql.append(W83bResultadosBD.totalelectores).append(", ").append(W83bResultadosBD.codsindicato).append(", ");
			strSql.append(W83bResultadosBD.siglas).append(", ").append(W83bResultadosBD.codconvenio).append(", ");
			strSql.append(W83bResultadosBD.convdesc).append(", ").append(W83bResultadosBD.convdese).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83bResultadosBD.totalvotos).append(", ");
			strSql.append(W83bResultadosBD.numdelegados).append(", ");
			strSql.append(W83bResultadosBD.nactacompleta).append(", ");
			strSql.append("  row_number() over ( ");
			strSql.append(" ORDER BY ");
			strSql.append(W83bResultadosBD.codconvenio);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.razon);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.nacta);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.territ);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.anoacta);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.ver);
			strSql.append(", ");
			strSql.append(W83bResultadosBD.codsindicato);
			strSql.append(") as rn");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
		}
		if(!StringUtils.isNotEmpty(param.getFechaHistorico())){	
			strSql.append(" FROM ").append(W83bResultadosBD.w83bdelegporconvdetcen);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.sector).append("=").append("? ");
				params.add(param.getSector());
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}		
			if(StringUtils.isNotEmpty(param.getConvenio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codconvenio).append("=").append("? ");
				params.add(param.getConvenio());
			}
			//Aadido por Eva, lo de la fecha de baja
//			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
//				strSql.append(" OR ("); 
//				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
//				strSql.append(" AND ");  
//				strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')");
//				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
//				strSql.append(" )");
				strSql.append(") ");  
//			}
			
		}else{
			strSql.append(" FROM ").append(W83bResultadosBD.w83bdelegporconvdetcenhist);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.sector).append("=").append("? ");
				params.add(param.getSector());
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}		
			if(StringUtils.isNotEmpty(param.getConvenio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codconvenio).append("=").append("? ");
				params.add(param.getConvenio());
			}
			//Aadido por Eva, lo de la fecha de baja
//			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) ");  
//			}
				
//				strSql.append(" AND (");
//				strSql.append(W83bResultadosBD.fechaActu).append("<=").append("TO_DATE(?,?) OR ");
//				strSql.append(W83bResultadosBD.fechaActu).append(" IS NULL) ");
				
				strSql.append(" AND ").append(W83bResultadosBD.ver).append(" = (select max(actas.");
				strSql.append(W83bActasBD.versionActa).append(") from ").append(W83bActasBD.actasTable).append(" actas ");
				strSql.append(" where (actas.");
				strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,?) ");
				params.add(param.getFeHist());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
				strSql.append(" or actas.").append(W83bActasBD.fechaActualizacion).append(" is null)");
				strSql.append(" AND actas.").append(W83bActasBD.anyoActa).append("= ").append(W83bResultadosBD.anoacta);
				strSql.append(" AND actas.");
				strSql.append(W83bActasBD.numActa).append("= ").append(W83bResultadosBD.nacta);
				strSql.append(" AND actas.");
				strSql.append(W83bActasBD.codTerritActa).append(" = ").append(W83bResultadosBD.territ);
				strSql.append(" AND actas.");
				strSql.append(W83bActasBD.validada).append("= ? )");
				params.add(W83bClsConstantes.CONSTANTE_VALIDADA);							
			
		}
		
		if(!contar & !(param.getMin().equals(param.getMax()))){
			strSql.append(") where (rn>? AND rn<=?)");
			params.add(param.getMin());
			params.add(param.getMax());				
		}
//		strSql.append(" ORDER BY ");
//		strSql.append(W83bResultadosBD.codconvenio);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.razon);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.nacta);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.territ);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.anoacta);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.ver);
//		strSql.append(", ");
//		strSql.append(W83bResultadosBD.codsindicato);
		
		
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "delegadosConvenioDetCentro");
		
		if(contar){
			return W83bDataBase.executeSimpleQuery(strSql.toString(),params,param.getUsuarioBean());			
		}else{
			return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapa);
		}
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#existeSector(w83b.w83bBeans.W83bResultadosBean)
	 */
	public java.util.List existeSector(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.descripsector);
		strSql.append(" FROM ").append(W83bResultadosBD.vistasectores);
		strSql.append(" WHERE ");
		if(StringUtils.isNotEmpty(param.getSector())){
			strSql.append(W83bResultadosBD.idsector).append("=?");
			params.add(param.getSector());
		}
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), param.getIdioma());
		
		return lista;		
	}
	
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#obtenerHashMapMunicipio(java.util.List)
	 */
	public HashMap obtenerHashMapMunicipio(List provincias) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");
       strSql.append(W83bResultadosBD.provinciaid).append(" AS ").append(W83bResultadosBD.codprovincia);
	    
	    strSql.append(", ");
	    strSql.append(W83bResultadosBD.id).append(" AS ").append(W83bResultadosBD.codmunicipio);
	    
	    strSql.append(", ");
	    strSql.append(W83bResultadosBD.dso).append(" AS ").append(W83bResultadosBD.municipio);
	    
	    strSql.append(", ");
	    		
	    strSql.append(W83bResultadosBD.comarcaid).append(" AS ").append(W83bResultadosBD.codcomarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bResultadosBD.tablamunicipio);
	    
	  
	    String prov="";
	   
		   for(int i=0;i<provincias.size();i++)
		   {
			   if(i==0)
			   {
				   strSql.append(" WHERE ");
			   }
		   prov=(String)provincias.get(i);
		   if (prov.length()==1){
		    	p="0"+prov;
		    }
		    else{
		    	p=prov;
		    }
		   
		   if(i!=0)
		   {
			   strSql.append(" OR ");
		   }
		   strSql.append(W83bResultadosBD.provinciaid).append(" = ?");
		   params.add(p);
		  
		   
	   }
	    
	    
			HashMap mapa = new HashMap();
			mapa.put("idioma", null);
			mapa.put("querie", "municipio");
		
	    List lista= W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,null,mapa);
	    HashMap resul=new HashMap();
	    W83bResultadosBean elem;
	    for(int i=0;i<lista.size();i++)
	    {
	    	elem=(W83bResultadosBean)lista.get(i);
	    	resul.put(elem.getCodprovincia()+"_"+elem.getCodmunicipio(), elem);
			
	    }
	    return resul;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#obtenerHashMapComarca(java.util.List)
	 */
	public HashMap obtenerHashMapComarca(List provincias) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		
		String p="";
		List params = new ArrayList();
		
	    strSql.append("SELECT ");
	    strSql.append(W83bResultadosBD.provinciaid).append(" AS ").append(W83bResultadosBD.codprovincia);
	    
	    strSql.append(", ");
	    strSql.append(W83bResultadosBD.id).append(" AS ").append(W83bResultadosBD.codcomarca);
	    
	    
	    strSql.append(", ");
	    		
	    strSql.append(W83bResultadosBD.dso).append(" AS ").append(W83bResultadosBD.comarca);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bResultadosBD.tablacomarca);
	    
	    String prov="";
		   
		   for(int i=0;i<provincias.size();i++)
		   {
			   if(i==0)
			   {
				   strSql.append(" WHERE ");
			   }
		   prov=(String)provincias.get(i);
		   if (prov.length()==1){
		    	p="0"+prov;
		    }
		    else{
		    	p=prov;
		    }
		   
		   if(i!=0)
		   {
			   strSql.append(" OR ");
		   }
		   strSql.append(W83bResultadosBD.provinciaid).append(" = ?");
		   params.add(p);
		  
		   
	   }
		   
		    
			HashMap mapa = new HashMap();
			mapa.put("idioma", null);
			mapa.put("querie", "comarca");
	    List lista= W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,null,mapa);
	    HashMap resul=new HashMap();
	    W83bResultadosBean elem;
	    for(int i=0;i<lista.size();i++)
	    {
	    	elem=(W83bResultadosBean)lista.get(i);
	    	resul.put(elem.getCodprovincia()+"_"+elem.getCodcomarca(), elem);
			
	    }
	    return resul;
			
		
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#obtenerHashMapProvincia(java.util.List)
	 */
	public HashMap obtenerHashMapProvincia(List provincias) throws Exception{
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);//NOPMD
		
		List params = new ArrayList();
		
	    strSql.append("SELECT ");

	    strSql.append(W83bResultadosBD.id).append(" AS ").append(W83bResultadosBD.codprovincia);
	    
	    
	    strSql.append(", ");
	    		
	    strSql.append(W83bResultadosBD.dso).append(" AS ").append(W83bResultadosBD.provincia);

	    strSql.append(" FROM ");
	    
	    strSql.append(W83bResultadosBD.tablaprovincia);
	    String prov="";
	    String p="";
		   
		   for(int i=0;i<provincias.size();i++)
		   {
			   if(i==0)
			   {
				   strSql.append(" WHERE ");
			   }
		   prov=(String)provincias.get(i);
		   if (prov.length()==1){
		    	p="0"+prov;
		    }
		    else{
		    	p=prov;
		    }
		   
		   if(i!=0)
		   {
			   strSql.append(" OR ");
		   }
		   strSql.append(W83bResultadosBD.id).append(" = ?");
		   params.add(p);		  
		   
	   }
		   
	    return W83bDataBase.executeQueryHashMap(strSql.toString(),params,W83bResultadosBean.class,null,null,W83bResultadosBD.codprovincia);
	  
	       
	}
	
	/**
	 * Aniadir grupo fechas.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirGrupoFechas(StringBuffer strSqlparam)
	{   StringBuffer strSql=strSqlparam;
		strSql=this.aniadirFechaRegistroDefinitivo(strSql);
		strSql=this.aniadirFechaEleccionDesde(strSql);
		strSql=this.aniadirFechaEleccionHasta(strSql);
		return strSql;
	}
	
	/**
	 * Aniadir grupo fechas.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirGrupoFechas(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{   List params=paramsp;
		params=this.aniadirFechaRegistroDefinitivo(params,param);
		params=this.aniadirFechaEleccionDesde(params,param);
		params=this.aniadirFechaEleccionHasta(params,param);
		return params;
	}
	
	/**
	 * Aniadir num acta.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirNumActa(StringBuffer strSqlparam)
	{
		StringBuffer strSql=strSqlparam;
		strSql.append(" AND ");	
		strSql.append(W83bResultadosBD.nactacompleta).append(" >= ?");
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.nactacompleta).append(" <= ?");
		
		return strSqlparam;
	}
	
	/**
	 * Aniadir num acta.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirNumActa(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		String desde = param.getAnoActaDesde();
		String hasta = param.getAnoActaHasta();
		String numDesde = param.getNumActaDesde();
		String numHasta = param.getNumActaHasta();
		if(StringUtils.isEmpty(param.getAnoActaHasta())){
			hasta = "9999";
		}
		if(StringUtils.isEmpty(param.getAnoActaDesde())){
			desde = "0000";
		}
		
		if(StringUtils.isEmpty(param.getNumActaHasta())){
			numHasta = "999999";
		}else if(6>param.getNumActaHasta().length()){
			for(int i = param.getNumActaHasta().length(),size = 6;i<size;i++){
				numHasta = "0"+numHasta;//NOPMD
			}
		}
		if(StringUtils.isEmpty(param.getNumActaDesde())){
			numDesde = "000000";
		}else if(6>param.getNumActaDesde().length()){
			for(int i = param.getNumActaDesde().length(),size = 6;i<size;i++){
				numDesde = "0"+numDesde;//NOPMD
			}
		}
		
		desde = desde + numDesde;//NOPMD
		hasta = hasta + numHasta;//NOPMD
		params.add(Long.valueOf(desde));
		params.add(Long.valueOf(hasta));
		return params;
	}
	
	/**
	 * Aniadir convenio.
	 *
	 * @param strSqlparam the str sqlparam
	 * @param param the param
	 * @return the string buffer
	 */
	private StringBuffer aniadirConvenio(StringBuffer strSqlparam,w83b.w83bBeans.W83bResultadosBean param)
	{
		StringBuffer strSql=strSqlparam;
		if(StringUtils.isNotEmpty(param.getConvenio()))
			{
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codconvenio).append("=").append("? ");
			}
			
		return strSqlparam;
	}
	
	/**
	 * Aniadir convenio.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirConvenio(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		if(StringUtils.isNotEmpty(param.getConvenio()))
				{
					params.add(param.getConvenio());
				}
		return params;
	}
	
	/**
	 * Aniadir sector.
	 *
	 * @param strSqlparam the str sqlparam
	 * @param param the param
	 * @return the string buffer
	 */
	private StringBuffer aniadirSector(StringBuffer strSqlparam,w83b.w83bBeans.W83bResultadosBean param)
	{
		StringBuffer strSql=strSqlparam;
		if(StringUtils.isNotEmpty(param.getSector()))
			{
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.sector).append("=").append("? ");
			}
			
		
		
		return strSqlparam;
	}
	
	/**
	 * Aniadir sector.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirSector(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		if(StringUtils.isNotEmpty(param.getSector()))
				{
					params.add(param.getSector());
				}
		return params;
	}
	/**
	 * Aniadir fecha baja.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirFechaBaja(StringBuffer strSqlparam,w83b.w83bBeans.W83bResultadosBean param)
	{
		StringBuffer strSql=strSqlparam;
		strSql.append(" AND (");
		strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL ");
		
		if(StringUtils.isNotEmpty(param.getFechaEleccionHasta()))
			{
				
				strSql.append(" OR ");
				//Modificado por Eva, antes estaba el slo el >
				strSql.append(W83bResultadosBD.fechabaja).append(">").append("TO_DATE(?,'dd/MM/yyyy') ");
				
			}
		strSql.append(" )");
		
		
		return strSqlparam;
	}
	/**
	 * Aniadir fecha baja.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaBaja(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		if(StringUtils.isNotEmpty(param.getFechaHistorico()))
				{
					params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				}
		return params;
	}
	/**
	 * Aniadir fecha registro definitivo.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirFechaRegistroDefinitivo(StringBuffer strSqlparam)
	{
		StringBuffer strSql=strSqlparam;
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		return strSqlparam;
	}
	
	/**
	 * Aniadir fecha registro definitivo.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaRegistroDefinitivo(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		return params;
	}
	/**
	 * Aniadir fecha historico.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
//	private StringBuffer aniadirFechaHistorico(StringBuffer strSqlparam)
//	{
//		StringBuffer strSql=strSqlparam;
//		strSql.append(" AND ");
//		strSql.append(W83bActasBD.fechaActualizacion).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
//		return strSqlparam;
//	}
	/**
	 * Aniadir fecha historico.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaHistorico(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		return params;
	}
	/**
	 * Aniadir fecha eleccion desde.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirFechaEleccionDesde(StringBuffer strSqlparam)
	{
		StringBuffer strSql=strSqlparam;
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
		return strSqlparam;
	}
	
	/**
	 * Aniadir fecha eleccion desde.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaEleccionDesde(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		return params;
	}
	
	/**
	 * Aniadir fecha eleccion hasta.
	 *
	 * @param strSqlparam the str sqlparam
	 * @return the string buffer
	 */
	private StringBuffer aniadirFechaEleccionHasta(StringBuffer strSqlparam)
	{
		StringBuffer strSql=strSqlparam;
		strSql.append(" AND ");
		strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
		return strSqlparam;
	}
	
	/**
	 * Aniadir fecha eleccion hasta.
	 *
	 * @param paramsp the paramsp
	 * @param param the param
	 * @return the list
	 * @throws ParseException the parse exception
	 * @throws Exception the exception
	 */
	private List aniadirFechaEleccionHasta(List paramsp, w83b.w83bBeans.W83bResultadosBean param) throws ParseException, Exception
	{
		List params=paramsp;
		params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
		return params;
	}



	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarResultadosCNAE(w83b.w83bBeans.W83bResultadosBean)
	 */
	public List buscarResultadosCNAE(W83bResultadosBean param) throws Exception {
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!StringUtils.isNotEmpty(param.getFechaHistorico())){
			strSql.append("SELECT TACT.");
			strSql.append(W83bResultadosBD.nacta).append(", TACT.");
			strSql.append(W83bResultadosBD.territ).append(", TACT.");
			strSql.append(W83bResultadosBD.anoacta).append(", TACT.");
			strSql.append(W83bResultadosBD.ver).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(", TACT.");
			strSql.append(W83bResultadosBD.sector).append(", TACT.");
			strSql.append(W83bResultadosBD.descsector).append(", TACT.");
			strSql.append(W83bResultadosBD.ncentro).append(", TACT.");
			strSql.append(W83bResultadosBD.totalelectores).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(", TACT.");
			strSql.append(W83bResultadosBD.idcnae).append(", TACT.");
			strSql.append(W83bResultadosBD.desccnae).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.numVotos).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.codigoColegio).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.delegadosHombres).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(", TACT.");
			strSql.append(W83bSindicatosBD.siglas).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.codSind);
			
			strSql.append(" FROM ").append(W83bResultadosBD.vistaResCNAE).append(" TACT");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			
			
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" TACT.");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechaRegistroDefinitivo());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,?)");
				params.add(param.getFechaEleccionDesde());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechaEleccionHasta());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append("AND UPPER(TACT.").append(W83bResultadosBD.sector).append(") like ?");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getSector().toUpperCase()).append("%").toString());
			}
			//Aadido por Eva, lo de la fecha de baja
//			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
//				strSql.append(" OR ("); 
//				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
//				strSql.append(" AND ");  
//				strSql.append(W83bResultadosBD.fechabaja).append(" >= ").append("TO_DATE(?, 'dd/MM/yyyy')");
//				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
//				strSql.append(" )");
				strSql.append(") ");  
//			}
		}else{
			strSql.append("SELECT TACT.");
			strSql.append(W83bResultadosBD.nacta).append(", TACT.");
			strSql.append(W83bResultadosBD.territ).append(", TACT.");
			strSql.append(W83bResultadosBD.anoacta).append(", TACT.");
			strSql.append(W83bResultadosBD.ver).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(", TACT.");
			strSql.append(W83bResultadosBD.sector).append(", TACT.");
			strSql.append(W83bResultadosBD.descsector).append(", TACT.");
			strSql.append(W83bResultadosBD.ncentro).append(", TACT.");
			strSql.append(W83bResultadosBD.totalelectores).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(", TACT.");
			strSql.append(W83bResultadosBD.idcnae).append(", TACT.");
			strSql.append(W83bResultadosBD.desccnae).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.numVotos).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.codigoColegio).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.delegadosHombres).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(", TACT.");
			strSql.append(W83bSindicatosBD.siglas).append(", TACT.");
			strSql.append(W83bEscrutiniosBD.codSind);
			
			strSql.append(" FROM ").append(W83bResultadosBD.vistaResCNAEhist).append(" TACT");
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			
			
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" TACT.");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechaRegistroDefinitivo());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,?)");
				params.add(param.getFechaEleccionDesde());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND TACT.");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,?)");
				params.add(param.getFechaEleccionHasta());
				params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			}
			if(StringUtils.isNotEmpty(param.getSector())){
				strSql.append("AND UPPER(TACT.").append(W83bResultadosBD.sector).append(") like ?");
				params.add(new StringBuffer(W83bClsConstantes.CUARENTA).append("%").append(param.getSector().toUpperCase()).append("%").toString());
			}
			strSql.append(" AND ").append(W83bResultadosBD.ver).append("=");
			strSql.append("(SELECT MAX(").append(W83bResultadosBD.VERSION_016).append(") AS vermax FROM ");
			strSql.append(W83bResultadosBD.tabla16).append(" WHERE TACT.").append(W83bResultadosBD.nacta);
			strSql.append("=").append(W83bResultadosBD.N_ACTA_016).append(" AND  TACT.").append(W83bResultadosBD.anoacta);
			strSql.append("=").append(W83bResultadosBD.ANO_ACTA_016).append(" AND  TACT.").append(W83bResultadosBD.territ);
			strSql.append("=").append(W83bResultadosBD.C_TERRIT_016).append(" AND (").append(W83bResultadosBD.factu_016);
			strSql.append("<= TO_DATE ('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59', 'dd/MM/yyyy hh24:mi:ss') OR ");
			strSql.append(W83bResultadosBD.factu_016).append(" IS NULL) ");
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1 )");
			
			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) ");  
			//}
		}
		List lista = W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), "RESULTADOSDELCNAE");
		
		return lista;
	}
	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarResultadosActaEscrutinio(w83b.w83bBeans.W83bActasBean)
	 */
	public List buscarResultadosActaEscrutinio(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT TESC.");
		strSql.append(W83bEscrutiniosBD.acta).append(", TESC.");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(", TESC.");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(", TESC.");
		strSql.append(W83bEscrutiniosBD.versionActa).append(", SUM(TESC.");
		strSql.append(W83bEscrutiniosBD.numVotos).append(") AS ").append(W83bEscrutiniosBD.numVotos).append(", COUNT(DISTINCT TESC.");
		strSql.append(W83bEscrutiniosBD.codigoColegio).append(") AS ").append(W83bEscrutiniosBD.codigoColegio).append(", SUM(TESC.");
		strSql.append(W83bEscrutiniosBD.delegadosHombres).append(") AS ").append(W83bEscrutiniosBD.delegadosHombres).append(", SUM(TESC.");
		strSql.append(W83bEscrutiniosBD.delegadosMujeres).append(") AS ").append(W83bEscrutiniosBD.delegadosMujeres).append(", TSIND.");
		strSql.append(W83bSindicatosBD.siglas).append(", TSIND.");
		strSql.append(W83bSindicatosBD.codSindicato);
		
		
		strSql.append(" FROM ").append(W83bEscrutiniosBD.escrutVista).append(" TESC, ");
		strSql.append(W83bSindicatosBD.sindicatosVista).append(" TSIND");
				
		strSql.append(" WHERE ");
		strSql.append(" TESC.");
		strSql.append(W83bEscrutiniosBD.acta).append(" = ").append("? ");
		params.add(param.getNacta());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.anyoActa).append(" = ").append("? ");
		params.add(param.getAnoacta());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.territorioActa).append(" = ").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.versionActa).append(" = ").append("? ");
		params.add(param.getVer());
		
		strSql.append(" AND TESC.");
		strSql.append(W83bEscrutiniosBD.codSind).append(" = ").append(" TSIND.").append(W83bSindicatosBD.codSindicato);
		strSql.append(" GROUP BY TSIND.").append(W83bSindicatosBD.codSindicato).append(", TSIND.").append(W83bSindicatosBD.siglas)
		.append(", TESC.").append(W83bEscrutiniosBD.acta).append(", TESC.").append(W83bEscrutiniosBD.anyoActa).append(", TESC.").append(W83bEscrutiniosBD.territorioActa).append(", TESC.").append(W83bEscrutiniosBD.versionActa);
	
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bEscrutinioBean.class,param.getUsuarioBean(), null);

	}

	
	/* (non-Javadoc)
	 * @see w83b.w83bDAO.W83bIResultadosDAO#buscarResultadosActaDiferencias(w83b.w83bBeans.W83bResultadosBean)
	 */
	public List buscarResultadosActaDiferencias(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT TDIF.");
		strSql.append(W83bDiferenciasBD.acta).append(", TDIF.");
		strSql.append(W83bDiferenciasBD.anyoActa).append(", TDIF.");
		strSql.append(W83bDiferenciasBD.territorioActa).append(", TDIF.");
		strSql.append(W83bDiferenciasBD.versionActa).append(", COUNT(DISTINCT TDIF.");
		strSql.append(W83bDiferenciasBD.codigoColegio).append(") AS ").append(W83bDiferenciasBD.codigoColegio).append(", SUM(TDIF.");
		strSql.append(W83bDiferenciasBD.delegadosHombres).append(") AS ").append(W83bDiferenciasBD.delegadosHombres).append(", SUM(TDIF.");
		strSql.append(W83bDiferenciasBD.delegadosMujeres).append(") AS ").append(W83bDiferenciasBD.delegadosMujeres).append(", TSIND.");
		strSql.append(W83bSindicatosBD.siglas).append(", TSIND.");
		strSql.append(W83bSindicatosBD.codSindicato);
		
		
		strSql.append(" FROM ").append(W83bDiferenciasBD.difVista).append(" TDIF, ");
		strSql.append(W83bSindicatosBD.sindicatosVista).append(" TSIND");
				
		strSql.append(" WHERE ");
		strSql.append(" TDIF.");
		strSql.append(W83bDiferenciasBD.acta).append(" = ").append("? ");
		params.add(param.getNacta());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.anyoActa).append(" = ").append("? ");
		params.add(param.getAnoacta());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.territorioActa).append(" = ").append("? ");
		params.add(param.getTerritorio());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.versionActa).append(" = ").append("? ");
		params.add(param.getVer());
		
		strSql.append(" AND TDIF.");
		strSql.append(W83bDiferenciasBD.codSind).append(" = ").append(" TSIND.").append(W83bSindicatosBD.codSindicato);

		strSql.append(" GROUP BY TSIND.").append(W83bSindicatosBD.codSindicato).append(", TSIND.").append(W83bSindicatosBD.siglas)
		.append(", TDIF.").append(W83bDiferenciasBD.acta).append(", TDIF.").append(W83bDiferenciasBD.anyoActa).append(", TDIF.").append(W83bDiferenciasBD.territorioActa).append(", TDIF.").append(W83bDiferenciasBD.versionActa);
		
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bDiferenciasBean.class,param.getUsuarioBean(), null);

	}
	
	public List obtenerNumEmpresasYCentros(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		strSql.append("SELECT "); 
		strSql.append(W83bResultadosBD.numcentros);
		strSql.append(" FROM TABLE (");
	    strSql.append(W83bResultadosBD.w83bnumempresasycentros);
	    strSql.append("(?,?,?,?,?,?,?))");
	    
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    if(StringUtils.isNotEmpty(param.getTerritorio())&&!"null".equals(param.getTerritorio())){
	    	params.add(param.getTerritorio());
	    }
	    else{
	    	params.add("todos");
	    }
	    if(StringUtils.isNotEmpty(param.getNumTrabajadores())){
	    	params.add(param.getNumTrabajadores());
	    }
	    else{
	    	params.add("todos");
	    }
	    if(StringUtils.isNotEmpty(param.getFechaHistorico())){
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    	params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
	    }
	    else{
	    	params.add("vacio");
	    	params.add("vacio");
	    }	 
		
		
		HashMap mapaQuerie = new HashMap();
		mapaQuerie.put("idioma", param.getIdioma());
		mapaQuerie.put("querie", "numempresasycentros");
	    
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(), mapaQuerie);	
		
	}
	
	public List buscarDelegAgrupConv(w83b.w83bBeans.W83bResultadosBean param) throws Exception{
		StringBuffer strSql = new StringBuffer();//NOPMD
		List params = new ArrayList();
		if(!StringUtils.isNotEmpty(param.getFechaHistorico())){
			strSql.append(" SELECT ");
			strSql.append(W83bResultadosBD.codagrup).append(", ");
			strSql.append(W83bResultadosBD.descagrup).append(", ");
			strSql.append(W83bResultadosBD.deseagrup).append(", ");
			strSql.append(W83bResultadosBD.codconvenio).append(", ");
			strSql.append(W83bResultadosBD.descconvenio).append(", ");
			strSql.append(W83bResultadosBD.deseconvenio).append(", ");
			strSql.append(W83bResultadosBD.codsindicato).append(", ");
			strSql.append(W83bResultadosBD.sinddesc).append(", ");
			strSql.append(W83bResultadosBD.sinddese).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83bResultadosBD.numdelegados);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" FROM w83b.").append(W83bResultadosBD.vistaDelegAgrupConv);
			strSql.append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getAgrupacion())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codagrup).append("=").append("? ");
				params.add(param.getAgrupacion());
			}	
			strSql.append(" AND ("); 
			strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
			strSql.append(") ");			
		}else{
			//20150514 se aade el listado del historico
			strSql.append(" SELECT ");
			strSql.append(W83bResultadosBD.codagrup).append(", ");
			strSql.append(W83bResultadosBD.descagrup).append(", ");
			strSql.append(W83bResultadosBD.deseagrup).append(", ");
			strSql.append(W83bResultadosBD.codconvenio).append(", ");
			strSql.append(W83bResultadosBD.descconvenio).append(", ");
			strSql.append(W83bResultadosBD.deseconvenio).append(", ");
			strSql.append(W83bResultadosBD.codsindicato).append(", ");
			strSql.append(W83bResultadosBD.sinddesc).append(", ");
			strSql.append(W83bResultadosBD.sinddese).append(", ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.felec).append(",?) AS ").append(W83bResultadosBD.felec).append(" , ");
			strSql.append("TO_CHAR(").append(W83bResultadosBD.fecharegistro).append(",?) AS ").append(W83bResultadosBD.fecharegistro).append(" , ");
			strSql.append(W83bResultadosBD.numdelegados);
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(param.getIdioma()));
			strSql.append(" FROM w83b.").append(W83bResultadosBD.vistaDelegAgrupConvHist +" DC,");
			
			strSql.append("(SELECT   MAX (").append(W83bResultadosBD.VERSION_016).append(") AS MAXVER, ");
			strSql.append(W83bResultadosBD.N_ACTA_016).append(",").append(W83bResultadosBD.ANO_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.C_TERRIT_016).append(" FROM ").append(W83bResultadosBD.tabla16).append(" WHERE ");
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				//strSql.append(" AND ");
				strSql.append(W83bResultadosBD.C_TERRIT_016).append("=").append("? ");
				params.add(param.getTerritorio());
				strSql.append(" AND ");				
			}
			strSql.append("  (").append(W83bResultadosBD.factu_016).append("<=TO_DATE('").append(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFeHist(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO)).append(" 23:59:59','dd/MM/yyyy hh24:mi:ss') OR ");
			strSql.append(W83bResultadosBD.factu_016).append(" IS NULL )");
			strSql.append(" AND ").append(W83bResultadosBD.validada_016).append("=1");
			strSql.append("GROUP BY ").append(W83bResultadosBD.N_ACTA_016).append(",");
			strSql.append(W83bResultadosBD.ANO_ACTA_016).append(",").append(W83bResultadosBD.C_TERRIT_016).append(") MAXRESULTS");
			
			strSql.append(" WHERE ");
			
			strSql.append(" DC.NACTA = MAXRESULTS.").append(W83bResultadosBD.N_ACTA_016 );
			strSql.append(" AND DC.ANOACTA = MAXRESULTS.").append(W83bResultadosBD.ANO_ACTA_016 );
			strSql.append(" AND DC.TERRIT = MAXRESULTS.").append(W83bResultadosBD.C_TERRIT_016 );
			
			if(StringUtils.isNotEmpty(param.getFechaRegistroDefinitivo())){
				strSql.append(" AND ");
				strSql.append("DC."+W83bResultadosBD.fecharegistro).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaRegistroDefinitivo(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionDesde())){
				strSql.append(" AND ");
				strSql.append("DC."+W83bResultadosBD.felec).append(">=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionDesde(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ");
				strSql.append("DC."+W83bResultadosBD.felec).append("<=").append("TO_DATE(?,'dd/MM/yyyy') ");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaEleccionHasta(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
			}
			if(StringUtils.isNotEmpty(param.getTerritorio())&&param.getTerritorio()!=null&&!"null".equals(param.getTerritorio())){
				strSql.append(" AND ");
				strSql.append("DC."+W83bResultadosBD.territ).append("=").append("? ");
				params.add(param.getTerritorio());
			}
			if(StringUtils.isNotEmpty(param.getAgrupacion())){
				strSql.append(" AND ");
				strSql.append(W83bResultadosBD.codagrup).append("=").append("? ");
				params.add(param.getAgrupacion());
			}	
			strSql.append(" AND ");
			strSql.append("DC.VER").append("=").append("MAXRESULTS.MAXVER ");
			//Aadido por Eva, lo de la fecha de baja
			//if(StringUtils.isNotEmpty(param.getFechaEleccionHasta())){
				strSql.append(" AND ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NULL");
				strSql.append(" OR ("); 
				strSql.append(W83bResultadosBD.fechabaja).append(" IS NOT NULL");
				strSql.append(" AND ");  
				strSql.append(W83bResultadosBD.fechabaja).append(" > ").append("TO_DATE(?, 'dd/MM/yyyy')");
				params.add(W83bDateUtil.getInstance().getLocaleStringFromDate(W83bDateUtil.getInstance().stringToDateIdioma(param.getFechaHistorico(),param.getIdioma()), W83bClsConstantes.CONSTANTE_CASTELLANO));
				strSql.append(" )) "); 
		}
			
	    
		HashMap mapa = new HashMap();
		mapa.put("idioma", param.getIdioma());
		mapa.put("querie", "delegadosAgrupConvenio");			
	
		return W83bDataBase.executeQuery(strSql.toString(),params,W83bResultadosBean.class,param.getUsuarioBean(),mapa );				
		
	}
	
}